<?php
if (!defined('ABSPATH')) exit;

$api_key = get_option('tnt_api_key', '');
$has_api_key = !empty($api_key);
?>

<div class="wrap tnt-admin">
    <h1>
        <span class="dashicons dashicons-camera" style="font-size: 30px; margin-right: 10px;"></span>
        <?php _e('Tap and Try', 'tap-and-try'); ?>
    </h1>
    
    <?php if (!$has_api_key) : ?>
        <div class="notice notice-warning">
            <p>
                <strong><?php _e('Welcome to Tap and Try!', 'tap-and-try'); ?></strong>
                <?php _e('To get started, please enter your API key in the', 'tap-and-try'); ?>
                <a href="<?php echo admin_url('admin.php?page=tap-and-try-settings'); ?>"><?php _e('Settings', 'tap-and-try'); ?></a>.
            </p>
            <p>
                <?php _e("Don't have an API key?", 'tap-and-try'); ?>
                <a href="https://dev.tapandtry.com/register" target="_blank"><?php _e('Get one free at tapandtry.com', 'tap-and-try'); ?></a>
            </p>
        </div>
    <?php endif; ?>
    
    <div class="tnt-dashboard-grid">
        <!-- Upgrade Banner (shown when over limit) -->
        <div id="tnt-upgrade-banner" class="tnt-card tnt-card-wide tnt-upgrade-banner" style="display: none;">
            <div class="tnt-upgrade-content">
                <div class="tnt-upgrade-icon">
                    <span class="dashicons dashicons-warning"></span>
                </div>
                <div class="tnt-upgrade-text">
                    <h3><?php _e('Product Limit Reached', 'tap-and-try'); ?></h3>
                    <p id="tnt-upgrade-message"><?php _e('You have more products than your current plan allows. Upgrade to enable more products for virtual try-on.', 'tap-and-try'); ?></p>
                </div>
                <div class="tnt-upgrade-action">
                    <button type="button" class="button button-primary tnt-upgrade-btn" onclick="tntOpenUpgrade('/pricing')">
                        <?php _e('Upgrade Plan', 'tap-and-try'); ?>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Usage Card -->
        <div class="tnt-card">
            <h2><?php _e('Usage', 'tap-and-try'); ?></h2>
            <div id="tnt-usage-stats">
                <?php if ($has_api_key) : ?>
                    <p class="tnt-loading"><?php _e('Loading...', 'tap-and-try'); ?></p>
                <?php else : ?>
                    <p class="tnt-muted"><?php _e('Connect your API key to see usage stats.', 'tap-and-try'); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Quick Actions Card -->
        <div class="tnt-card">
            <h2><?php _e('Quick Actions', 'tap-and-try'); ?></h2>
            <div class="tnt-actions">
                <a href="<?php echo admin_url('admin.php?page=tap-and-try-products'); ?>" class="button button-primary">
                    <?php _e('Manage Products', 'tap-and-try'); ?>
                </a>
                <button id="tnt-sync-all" class="button" <?php echo !$has_api_key ? 'disabled' : ''; ?>>
                    <?php _e('Sync All Products', 'tap-and-try'); ?>
                </button>
                <a href="<?php echo admin_url('admin.php?page=tap-and-try-settings'); ?>" class="button">
                    <?php _e('Settings', 'tap-and-try'); ?>
                </a>
            </div>
        </div>
        
        <!-- Getting Started Card -->
        <div class="tnt-card tnt-card-wide">
            <h2><?php _e('Getting Started', 'tap-and-try'); ?></h2>
            <ol class="tnt-steps">
                <li>
                    <strong><?php _e('Get your API key', 'tap-and-try'); ?></strong>
                    <p><?php _e('Sign up at tapandtry.com and generate an API key from your dashboard.', 'tap-and-try'); ?></p>
                </li>
                <li>
                    <strong><?php _e('Enter your API key', 'tap-and-try'); ?></strong>
                    <p><?php _e('Go to Settings and paste your API key to connect your store.', 'tap-and-try'); ?></p>
                </li>
                <li>
                    <strong><?php _e('Enable products', 'tap-and-try'); ?></strong>
                    <p><?php _e('Select which products you want to enable for virtual try-on. Free plan includes 6 products.', 'tap-and-try'); ?></p>
                </li>
                <li>
                    <strong><?php _e('Upload product images', 'tap-and-try'); ?></strong>
                    <p><?php _e('Add product images with transparent backgrounds, or let us remove backgrounds automatically.', 'tap-and-try'); ?></p>
                </li>
            </ol>
        </div>
        
        <!-- Tap & Try Dashboard Card -->
        <?php if ($has_api_key) : ?>
        <div class="tnt-card">
            <h2><?php _e('Tap & Try Dashboard', 'tap-and-try'); ?></h2>
            <p class="tnt-muted"><?php _e('Access advanced features on tapandtry.com', 'tap-and-try'); ?></p>
            <ul class="tnt-dashboard-links">
                <li>
                    <button type="button" class="tnt-link-btn" onclick="tntOpenUpgrade('/dashboard')">
                        <span class="dashicons dashicons-chart-bar"></span>
                        <?php _e('View Analytics', 'tap-and-try'); ?>
                    </button>
                    <span class="tnt-link-desc"><?php _e('Views, clicks, conversions', 'tap-and-try'); ?></span>
                </li>
                <li>
                    <button type="button" class="tnt-link-btn" onclick="tntOpenUpgrade('/dashboard/products')">
                        <span class="dashicons dashicons-screenoptions"></span>
                        <?php _e('Manage Products', 'tap-and-try'); ?>
                    </button>
                    <span class="tnt-link-desc"><?php _e('QR codes, variants, images', 'tap-and-try'); ?></span>
                </li>
                <li>
                    <button type="button" class="tnt-link-btn" onclick="tntOpenUpgrade('/dashboard/settings/store')">
                        <span class="dashicons dashicons-store"></span>
                        <?php _e('Store Settings', 'tap-and-try'); ?>
                    </button>
                    <span class="tnt-link-desc"><?php _e('Branding, marketplace', 'tap-and-try'); ?></span>
                </li>
                <li>
                    <button type="button" class="tnt-link-btn" onclick="tntOpenUpgrade('/dashboard/settings/billing')">
                        <span class="dashicons dashicons-money-alt"></span>
                        <?php _e('Billing & Plans', 'tap-and-try'); ?>
                    </button>
                    <span class="tnt-link-desc"><?php _e('Subscription, invoices', 'tap-and-try'); ?></span>
                </li>
            </ul>
        </div>
        <?php endif; ?>
        
        <!-- Help Card -->
        <div class="tnt-card">
            <h2><?php _e('Need Help?', 'tap-and-try'); ?></h2>
            <ul class="tnt-help-links">
                <li>
                    <a href="https://support.tapandtry.com" target="_blank">
                        <?php _e('Help Center', 'tap-and-try'); ?>
                    </a>
                </li>
                <li>
                    <a href="https://support.tapandtry.com" target="_blank">
                        <?php _e('Contact Support', 'tap-and-try'); ?>
                    </a>
                </li>
                <li>
                    <button type="button" class="tnt-text-link" onclick="tntOpenUpgrade('/pricing')">
                        <?php _e('Upgrade Plan', 'tap-and-try'); ?>
                    </button>
                </li>
            </ul>
        </div>
    </div>
</div>

<style>
.tnt-admin {
    max-width: 1200px;
}
.tnt-dashboard-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
    margin-top: 20px;
}
.tnt-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
}
.tnt-card-wide {
    grid-column: span 2;
}
.tnt-card h2 {
    margin-top: 0;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}
.tnt-actions {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
}
.tnt-steps {
    margin: 0;
    padding-left: 20px;
}
.tnt-steps li {
    margin-bottom: 15px;
}
.tnt-steps p {
    margin: 5px 0 0;
    color: #666;
}
.tnt-help-links {
    margin: 0;
    padding: 0;
    list-style: none;
}
.tnt-help-links li {
    margin-bottom: 10px;
}
.tnt-muted {
    color: #666;
    font-style: italic;
}
.tnt-dashboard-links {
    margin: 15px 0 0;
    padding: 0;
    list-style: none;
}
.tnt-dashboard-links li {
    margin-bottom: 12px;
    display: flex;
    align-items: center;
    gap: 10px;
    flex-wrap: wrap;
}
.tnt-link-btn {
    background: none;
    border: none;
    color: #2271b1;
    cursor: pointer;
    padding: 0;
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 6px;
}
.tnt-link-btn:hover {
    color: #135e96;
    text-decoration: underline;
}
.tnt-link-btn .dashicons {
    font-size: 18px;
    width: 18px;
    height: 18px;
}
.tnt-link-desc {
    color: #666;
    font-size: 12px;
}
.tnt-text-link {
    background: none;
    border: none;
    color: #2271b1;
    cursor: pointer;
    padding: 0;
    font-size: inherit;
}
.tnt-text-link:hover {
    color: #135e96;
    text-decoration: underline;
}
.tnt-loading {
    color: #666;
}
.tnt-upgrade-banner {
    background: linear-gradient(135deg, #fff3cd 0%, #ffeeba 100%);
    border: 1px solid #ffc107;
    border-left: 4px solid #ffc107;
}
.tnt-upgrade-content {
    display: flex;
    align-items: center;
    gap: 20px;
    flex-wrap: wrap;
}
.tnt-upgrade-icon {
    flex-shrink: 0;
}
.tnt-upgrade-icon .dashicons {
    font-size: 40px;
    width: 40px;
    height: 40px;
    color: #856404;
}
.tnt-upgrade-text {
    flex: 1;
    min-width: 200px;
}
.tnt-upgrade-text h3 {
    margin: 0 0 5px;
    color: #856404;
}
.tnt-upgrade-text p {
    margin: 0;
    color: #856404;
}
.tnt-upgrade-action {
    flex-shrink: 0;
}
.tnt-upgrade-btn {
    background: #ffc107 !important;
    border-color: #e0a800 !important;
    color: #212529 !important;
    font-weight: 600;
    padding: 8px 20px !important;
}
.tnt-upgrade-btn:hover {
    background: #e0a800 !important;
}
.tnt-usage-warning {
    color: #856404;
}
.tnt-usage-bar-fill.warning {
    background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
}
.tnt-usage-bar-fill.danger {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
}
.tnt-usage-item {
    display: flex;
    justify-content: space-between;
    padding: 8px 0;
    border-bottom: 1px solid #eee;
}
.tnt-usage-item:last-child {
    border-bottom: none;
}
.tnt-usage-bar {
    height: 8px;
    background: #e0e0e0;
    border-radius: 4px;
    margin-top: 5px;
    overflow: hidden;
}
.tnt-usage-bar-fill {
    height: 100%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 4px;
    transition: width 0.3s;
}
@media (max-width: 782px) {
    .tnt-card-wide {
        grid-column: span 1;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    // Load usage stats
    <?php if ($has_api_key) : ?>
    $.post(tntAdmin.ajaxUrl, {
        action: 'tnt_get_usage',
        nonce: tntAdmin.nonce
    }, function(response) {
        if (response.success) {
            var data = response.data;
            var isOverLimit = data.limits.maxProducts > 0 && data.usage.products > data.limits.maxProducts;
            var isAtLimit = data.limits.maxProducts > 0 && data.usage.products >= data.limits.maxProducts;
            var warningClass = isOverLimit ? 'danger' : (isAtLimit ? 'warning' : '');
            
            var html = '<div class="tnt-usage-item">' +
                '<span>Plan</span>' +
                '<strong>' + data.plan.charAt(0).toUpperCase() + data.plan.slice(1) + '</strong>' +
                '</div>' +
                '<div class="tnt-usage-item' + (isOverLimit ? ' tnt-usage-warning' : '') + '">' +
                '<span>Products</span>' +
                '<strong>' + data.usage.products + ' / ' + (data.limits.maxProducts === -1 ? '∞' : data.limits.maxProducts) + '</strong>' +
                '</div>';
            
            if (data.limits.maxProducts > 0) {
                var percent = Math.min(100, (data.usage.products / data.limits.maxProducts) * 100);
                html += '<div class="tnt-usage-bar"><div class="tnt-usage-bar-fill ' + warningClass + '" style="width: ' + percent + '%"></div></div>';
            }
            
            $('#tnt-usage-stats').html(html);
            
            // Show upgrade banner if over limit
            if (isOverLimit) {
                var overBy = data.usage.products - data.limits.maxProducts;
                $('#tnt-upgrade-message').text(
                    'You have ' + data.usage.products + ' products but your ' + data.plan.charAt(0).toUpperCase() + data.plan.slice(1) + 
                    ' plan only allows ' + data.limits.maxProducts + '. ' +
                    'Upgrade to enable all your products for virtual try-on.'
                );
                $('#tnt-upgrade-banner').slideDown();
            }
        } else {
            $('#tnt-usage-stats').html('<p class="tnt-muted">Failed to load usage data.</p>');
        }
    });
    <?php endif; ?>
    
    // Auto-login redirect helper
    window.tntOpenUpgrade = function(redirectTo) {
        $.post(tntAdmin.ajaxUrl, {
            action: 'tnt_get_login_url',
            nonce: tntAdmin.nonce,
            redirect_to: redirectTo || '/pricing'
        }, function(response) {
            if (response.success && response.data.loginUrl) {
                window.open(response.data.loginUrl, '_blank');
            } else {
                // Fallback to direct link if auto-login fails
                window.open('https://tapandtry.com' + (redirectTo || '/pricing'), '_blank');
            }
        }).fail(function() {
            window.open('https://tapandtry.com' + (redirectTo || '/pricing'), '_blank');
        });
    };
    
    // Sync all products
    $('#tnt-sync-all').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text(tntAdmin.strings.syncing);
        
        $.post(tntAdmin.ajaxUrl, {
            action: 'tnt_sync_products',
            nonce: tntAdmin.nonce
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
            } else {
                alert(tntAdmin.strings.syncError);
            }
            $btn.prop('disabled', false).text('Sync All Products');
        });
    });
});
</script>
